/*
 * Decompiled with CFR 0.152.
 */
package com.zkryle.jeg.common.tileentities;

import com.zkryle.jeg.common.ICoreOwner;
import com.zkryle.jeg.core.Init;
import net.minecraft.block.BlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ChargingTableTileEntity
extends TileEntity
implements ITickableTileEntity,
ICoreOwner {
    protected ItemStack core = ItemStack.field_190927_a;
    private short charge = 0;
    private short rotationAnim = 0;
    private byte soundTick = (byte)50;
    private boolean startedLoop = false;

    protected ChargingTableTileEntity(TileEntityType<?> typeIn) {
        super(typeIn);
    }

    public ChargingTableTileEntity() {
        this((TileEntityType)Init.CHARGING_TABLE_TILE_ENTITY_TYPE.get());
    }

    public CompoundNBT func_189515_b(CompoundNBT pCompound) {
        CompoundNBT core = new CompoundNBT();
        this.core.func_77955_b(core);
        pCompound.func_74777_a("CHARGE", this.charge);
        pCompound.func_218657_a("CORE", (INBT)core);
        return super.func_189515_b(pCompound);
    }

    public void func_230337_a_(BlockState pState, CompoundNBT pCompound) {
        this.setCore(ItemStack.func_199557_a((CompoundNBT)((CompoundNBT)pCompound.func_74781_a("CORE"))).func_77946_l());
        this.setCharge(pCompound.func_74765_d("CHARGE"));
        super.func_230337_a_(pState, pCompound);
    }

    public CompoundNBT func_189517_E_() {
        return this.func_189515_b(new CompoundNBT());
    }

    public SUpdateTileEntityPacket func_189518_D_() {
        CompoundNBT nbt = new CompoundNBT();
        this.func_189515_b(nbt);
        this.func_70296_d();
        return new SUpdateTileEntityPacket(this.func_174877_v(), 0, nbt);
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket packet) {
        CompoundNBT tag = packet.func_148857_g();
        this.func_230337_a_(this.field_145850_b.func_180495_p(this.field_174879_c), tag);
        this.func_70296_d();
        this.field_145850_b.func_184138_a(this.field_174879_c, this.field_145850_b.func_180495_p(this.field_174879_c).func_177230_c().func_176223_P(), this.field_145850_b.func_180495_p(this.field_174879_c), 2);
    }

    public void func_73660_a() {
        if (this.field_145850_b.func_201670_d()) {
            if (this.rotationAnim < 360) {
                if (this.getCorePercentage() > 10.0f) {
                    this.rotationAnim = (short)((float)this.rotationAnim + this.getCorePercentage() / 10.0f);
                }
            } else {
                this.resetRotationAnim();
            }
        }
        if (this.hasCore()) {
            if (this.charge > 0) {
                if (this.getCore().func_77952_i() > 0) {
                    this.getCore().func_196085_b(this.core.func_77952_i() - 1);
                }
                this.charge = (short)(this.charge - 1);
            }
            if (this.soundTick == 0) {
                this.playLoop();
                this.soundTick = (byte)105;
            }
            this.soundTick = (byte)(this.soundTick - 1);
            this.soundTick = (byte)Math.max(0, this.soundTick);
        } else {
            this.soundTick = 0;
        }
    }

    @Override
    public boolean hasCore() {
        return !this.core.func_190926_b();
    }

    @Override
    public void setCore(ItemStack core) {
        if (core.func_190926_b()) {
            this.playLoopEnd();
        } else {
            this.soundTick = 0;
        }
        this.core = core;
    }

    @Override
    public ItemStack getCore() {
        return this.core;
    }

    @Override
    public boolean isDelayElapsed() {
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public short getRotationAnim() {
        return this.rotationAnim;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void resetRotationAnim() {
        this.rotationAnim = 0;
    }

    public void setCharge(short charge) {
        this.charge = charge;
    }

    public short getCharge() {
        return this.charge;
    }

    private void playLoop() {
        if (!this.field_145850_b.func_201670_d()) {
            this.field_145850_b.func_184133_a(null, this.func_174877_v(), (SoundEvent)Init.CHARGING_STATION_LOOP.get(), SoundCategory.BLOCKS, 0.05f, 1.0f);
        }
    }

    private void playLoopEnd() {
        if (!this.field_145850_b.func_201670_d()) {
            this.field_145850_b.func_184133_a(null, this.func_174877_v(), (SoundEvent)Init.CHARGING_STATION_LOOP_END.get(), SoundCategory.BLOCKS, 0.05f, 1.0f);
        }
    }
}

